/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.heal;

import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.client.animation.InfiniteAnimation;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.common.AnimationPaths;
import dev.toma.gunsrpg.common.item.heal.AbstractHealItem;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_AnimationPacket;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContinuousHealingItem
extends AbstractHealItem<PlayerEntity> {
    private final int medPrepareDelay;

    private ContinuousHealingItem(Builder builder) {
        super(builder, new Item.Properties().func_200918_c(builder.useCount));
        this.medPrepareDelay = builder.medPrepareDelay;
    }

    public static Builder define(String name) {
        return new Builder(name);
    }

    @Override
    public PlayerEntity getTargetObject(World world, PlayerEntity user, IPlayerData data) {
        return user;
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return stack.func_77958_k() * this.getUseTime() + 1;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int usingTime = this.func_77626_a(stack) - timeLeft;
        if (usingTime < this.medPrepareDelay) {
            return;
        }
        int ticksBeforeEffect = (usingTime - this.medPrepareDelay) % this.getUseTime();
        if (ticksBeforeEffect == 0 && entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            this.applyAction(player);
            stack.func_222118_a(1, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            if (!this.getUseCondition().test(player)) {
                player.func_184602_cy();
                NetworkManager.sendClientPacket(player, new S2C_AnimationPacket(S2C_AnimationPacket.Action.STOP, AnimationPaths.HEAL_TYPE));
            }
        }
    }

    @Override
    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            this.cancelHealAnimation();
        }
        return stack;
    }

    @Override
    protected int getAnimationLength() {
        return this.medPrepareDelay;
    }

    @Override
    protected IAnimation constructAnimation(IKeyframeProvider provider, int length) {
        return new InfiniteAnimation(provider, length);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cancelHealAnimation() {
        AnimationEngine engine = AnimationEngine.get();
        IAnimationPipeline pipeline = engine.pipeline();
        pipeline.remove(ModAnimations.HEAL);
    }

    public static class Builder
    extends AbstractHealItem.HealBuilder<PlayerEntity, ContinuousHealingItem> {
        private int useCount;
        private int medPrepareDelay;

        private Builder(String name) {
            super(name);
        }

        public Builder uses(int useCount) {
            this.useCount = useCount;
            return this;
        }

        public Builder prepareIn(int ticks) {
            this.medPrepareDelay = ticks;
            return this;
        }

        @Override
        public ContinuousHealingItem build() {
            return new ContinuousHealingItem(this);
        }
    }
}

